module X = Xmlerr
let () =
  let xs = X.parse_file ~filename:Sys.argv.(1) in
  let rec aux_pre xs =
    match xs with [] -> []
    | X.Tag ("a", ["href", url]) ::
      X.Data link ::
      X.ETag ("a") :: xs ->
        Printf.printf "[%s](%s)" link url ; aux_pre xs
    | X.Data pre :: xs ->
        Printf.printf "%s" pre ; aux_pre xs
    | X.Tag ("i", _) :: X.Data b ::
      X.ETag ("i") :: xs ->
        Printf.printf "*%s*" b ; aux_pre xs
    | X.Tag ("b", _) :: X.Data b ::
      X.ETag ("b") :: xs ->
        Printf.printf "**%s**" b ; aux_pre xs
    | X.ETag ("pre") :: xs -> xs
    | _ :: xs -> aux_pre xs
  in
  let rec aux_p xs =
    match xs with [] -> []
    | X.Tag ("b", _) :: X.Data b ::
      X.ETag ("b") :: xs ->
        Printf.printf "**%s**" b ; aux_p xs
    | X.Tag ("i", _) :: X.Data em ::
      X.ETag ("i") :: xs ->
        Printf.printf "*%s*" em ; aux_p xs
    | X.Tag ("em", _) :: X.Data em ::
      X.ETag ("em") :: xs ->
        Printf.printf "*%s*" em ; aux_p xs
    | X.Tag ("code", _) :: X.Data code ::
      X.ETag ("code") :: xs ->
        Printf.printf "`%s`" code ; aux_p xs
    | X.Data p :: xs ->
        Printf.printf "%s%!" p ; aux_p xs
    | X.ETag ("p") :: xs ->
        Printf.printf "\n\n%!" ; xs
    | X.Tag ("br", _) ::
      X.ETag ("br") :: xs ->
        Printf.printf "  %!" ; aux_p xs
    | X.Tag ("a", ["href", url]) ::
      X.Data link ::
      X.ETag ("a") :: xs ->
        Printf.printf "[%s](%s)" link url ; aux_p xs
    | X.Tag ("i", []) ::
      X.Tag ("a", ["href", url]) ::
      X.Data link ::
      X.ETag ("a") ::
      X.ETag ("i") :: xs ->
        Printf.printf "*[%s](%s)*" link url ; aux_p xs
    | X.Tag ("b", []) ::
      X.Tag ("a", ["href", url]) ::
      X.Data link ::
      X.ETag ("a") ::
      X.ETag ("b") :: xs ->
        Printf.printf "**[%s](%s)**" link url ; aux_p xs
    | _ :: xs -> aux_p xs
  in
  let rec aux_td d xs =
    match xs with [] -> []
    | X.Tag ("td", _) :: xs -> aux_td 1 xs
    | X.ETag ("td") :: xs ->
        Printf.printf " | %!" ; aux_td 0 xs
    | X.Data td :: xs -> if d = 1 then
        Printf.printf " %s %!" td ; aux_td d xs
    | X.ETag ("tr") :: xs ->
        Printf.printf "\n%!" ; xs
    | X.Tag ("b", _) :: X.Data td ::
      X.ETag ("b") :: xs -> if d = 1 then
        Printf.printf " **%s** " td ; aux_td d xs
    | X.Tag ("a", ["href", url]) ::
      X.Data link ::
      X.ETag ("a") :: xs ->
        Printf.printf "[%s](%s)" link url ; aux_td d xs
    | X.Tag ("p", _) :: xs -> let xs = aux_p xs in aux_td d xs
    | _ :: xs -> aux_td d xs
  in
  let rec aux_table xs =
    match xs with [] -> []
    | X.Tag ("tr", _) :: xs ->
        Printf.printf "\n| %!" ; aux_td 0 xs
    | X.ETag ("table") :: xs ->
        Printf.printf "\n\n%!" ; xs
    | _ :: xs -> aux_table xs
  in
  let rec aux_ul xs =
    match xs with [] -> []
    | X.Tag ("li", _) :: xs ->
        Printf.printf "- %!" ; aux_ul xs
    | X.Tag ("a", ["href", url]) ::
      X.Data link ::
      X.ETag ("a") :: xs ->
        Printf.printf "[%s](%s)" link url ; aux_ul xs
    | X.Data p :: xs ->
        Printf.printf "%s%!" p ; aux_ul xs
    | X.ETag ("li") :: xs ->
        Printf.printf "%!" ; aux_ul xs
    | X.Tag ("p", _) :: xs -> let xs = aux_p xs in aux_ul xs
    | _ :: xs -> aux_ul xs
  in
  let rec aux_body xs =
    match xs with [] -> []
    | X.ETag ("body") :: xs -> xs
    | X.Tag ("h3", _) :: X.Data h3 ::
      X.ETag ("h3") :: xs ->
        Printf.printf "### %s\n\n%!" h3 ; aux_body xs
    | X.Tag ("h2", _) :: X.Data h2 ::
      X.ETag ("h2") :: xs ->
        Printf.printf "## %s\n\n%!" h2 ; aux_body xs
    | X.Tag ("h1", _) :: X.Data h1 ::
      X.ETag ("h1") :: xs ->
        Printf.printf "# %s\n\n%!" h1 ; aux_body xs
    | X.Tag ("hr", _) ::
      X.ETag ("hr") :: xs ->
        Printf.printf "---\n\n%!" ; aux_body xs
    | X.Tag ("pre", _) :: X.Data pre ::
      X.ETag ("pre") :: xs ->
        Printf.printf "```%s```\n\n%!" pre ; aux_body xs
    | X.Tag ("pre", _) :: xs ->
        Printf.printf "```%!" ;
        let xs = aux_pre xs in
        Printf.printf "```\n\n%!" ;
        aux_body xs
    | X.Tag ("img", ["src", url; "title", ttl]) ::
      X.ETag ("img") :: xs ->
        Printf.printf "![%s](%s)\n\n%!" ttl url ; aux_body xs
    | X.Tag ("img", ["src", url]) ::
      X.ETag ("img") :: xs ->
        Printf.printf "![](%s)\n\n%!" url ; aux_body xs
    | X.Tag ("p", _) :: xs -> let xs = aux_p xs in aux_body xs
    | X.Tag ("ul", _) :: xs -> let xs = aux_ul xs in aux_body xs
    | X.Tag ("table", _) :: xs -> let xs = aux_table xs in aux_body xs
    | X.Comm _ :: xs -> aux_body xs
    | _ :: xs -> aux_body xs
  in
  let rec aux xs =
    match xs with [] -> ()
    | X.Tag ("body", _) :: xs ->
        (* Printf.printf "@BODY:\n\n%!" ; *)
        let xs = aux_body xs in aux xs
    | X.Tag (tag, _) :: xs ->
        (* Printf.printf "@tag: %s\n%!" tag ; *)
        aux xs
    | X.ETag (tag) :: xs ->
        (* Printf.printf "\\@tag %s\n%!" tag ; *)
        aux xs
    | X.Data d :: xs ->
        (* Printf.printf "@data: %s\n%!" d ; *)
        aux xs
    | xs -> aux xs
  in
  aux xs
