type document  // abstract type for a document object
type context

@val external document: document = "document"
@val external window: Dom.element = "window"

@send external getElementById: (document, string) => Dom.element = "getElementById"
@send external getContext: (Dom.element, string) => context = "getContext"

@set external fillStyle: (context, string) => unit = "fillStyle"
@set external strokeStyle: (context, string) => unit = "strokeStyle"
@set external lineWidth: (context, float) => unit = "lineWidth"

@send external fillRect: (context, int, int, int, int) => unit = "fillRect"
@send external arc: (context, float, float, float, float, float, bool) => unit = "arc"

@send external beginPath: context => unit = "beginPath"
@send external closePath: context => unit = "closePath"

@send external fill: context => unit = "fill"
@send external stroke: context => unit = "stroke"

@send external moveTo: (context, float, float) => unit = "moveTo"
@send external lineTo: (context, float, float) => unit = "lineTo"

@send external translate: (context, int, int) => unit = "translate"
@send external rotate: (context, float) => unit = "rotate"
@send external scale: (context, float, float) => unit = "scale"

type intervalID

@val external setInterval: (unit => unit, int) => intervalID = "setInterval"

@val external console_log: string => unit = "console.log"

