// Generated by ReScript, PLEASE EDIT WITH CARE
'use strict';






var canvas = document.getElementById("my_canvas");

var ctx = canvas.getContext("2d");

var blue = "#00F";

var white = "#FFF";

var black = "#000";

function draw_circle(color, circle) {
  ctx.strokeStyle = color;
  ctx.beginPath();
  ctx.lineWidth = 1.8;
  ctx.arc(circle.cx, circle.cy, circle.r, 0.0, 6.28, false);
  ctx.closePath();
  ctx.fill();
  ctx.stroke();
  
}

function draw_segment(color, segment) {
  var p2 = segment[1];
  var p1 = segment[0];
  ctx.strokeStyle = color;
  ctx.lineWidth = 1.4;
  ctx.beginPath();
  ctx.moveTo(p1[0], p1[1]);
  ctx.lineTo(p2[0], p2[1]);
  ctx.closePath();
  ctx.stroke();
  
}

function display_demo(circles, segments) {
  ctx.fillStyle = blue;
  ctx.fillRect(0, 0, 480, 340);
  List.iter((function (param) {
          return draw_circle(black, param);
        }), circles);
  List.iter((function (param) {
          return draw_segment(white, param);
        }), segments);
  
}

Random.self_init(undefined);

var rand_circles = List.init(12, (function (param) {
        return {
                cx: 160.0 + Random.$$float(320.0),
                cy: 10.0 + Random.$$float(60.0),
                r: 4.0 + Random.$$float(10.0),
                vx: 2.0 - Random.$$float(4.0),
                vy: 0.0,
                static: false,
                custom: undefined
              };
      }));

var circles = {
  contents: Pervasives.$at({
        hd: {
          cx: 100.0,
          cy: 50.0,
          r: 8.4,
          vx: 2.0,
          vy: 0.0,
          static: false,
          custom: undefined
        },
        tl: {
          hd: {
            cx: 30.0,
            cy: 10.0,
            r: 12.6,
            vx: -1.0,
            vy: 0.0,
            static: false,
            custom: undefined
          },
          tl: {
            hd: {
              cx: 60.0,
              cy: 20.0,
              r: 10.9,
              vx: 1.4,
              vy: 0.0,
              static: false,
              custom: undefined
            },
            tl: {
              hd: {
                cx: 80.0,
                cy: 50.0,
                r: 9.6,
                vx: -0.6,
                vy: 0.0,
                static: false,
                custom: undefined
              },
              tl: {
                hd: {
                  cx: 120.0,
                  cy: 30.0,
                  r: 6.2,
                  vx: 0.8,
                  vy: 0.0,
                  static: false,
                  custom: undefined
                },
                tl: /* [] */0
              }
            }
          }
        }
      }, rand_circles)
};

var segments = {
  hd: [
    [
      10.0,
      330.0
    ],
    [
      470.0,
      330.0
    ]
  ],
  tl: {
    hd: [
      [
        390.0,
        210.0
      ],
      [
        430.0,
        210.0
      ]
    ],
    tl: {
      hd: [
        [
          80.0,
          180.0
        ],
        [
          280.0,
          220.0
        ]
      ],
      tl: {
        hd: [
          [
            290.0,
            300.0
          ],
          [
            370.0,
            270.0
          ]
        ],
        tl: {
          hd: [
            [
              10.0,
              330.0
            ],
            [
              10.0,
              120.0
            ]
          ],
          tl: {
            hd: [
              [
                470.0,
                330.0
              ],
              [
                470.0,
                120.0
              ]
            ],
            tl: /* [] */0
          }
        }
      }
    }
  }
};

function animate(param) {
  circles.contents = Gphys.update_circles(circles.contents, segments, [
        0.0,
        1.6
      ], 0.2, 0.8);
  display_demo(circles.contents, segments);
  
}

setInterval(animate, 41);

var width = 480;

var height = 340;

var red = "#F00";

var green = "#0F0";

var bg_color = blue;

var seg_color = white;

var circ_color = black;
















/* canvas Not a pure module */
