// Generated by ReScript, PLEASE EDIT WITH CARE
'use strict';



function apply_gravity(circle, param, dt) {
  return {
          cx: circle.cx,
          cy: circle.cy,
          r: circle.r,
          vx: circle.vx + param[0] * dt,
          vy: circle.vy + param[1] * dt,
          static: circle.static,
          custom: circle.custom
        };
}

function normalize_vector(param) {
  var y = param[1];
  var x = param[0];
  var magnitude = Math.sqrt(x * x + y * y);
  if (magnitude === 0) {
    return [
            0,
            0
          ];
  } else {
    return [
            x / magnitude,
            y / magnitude
          ];
  }
}

function collision_circle_segment(circle, param, restitution) {
  if (circle.static) {
    return circle;
  }
  var match = param[1];
  var p2y = match[1];
  var p2x = match[0];
  var match$1 = param[0];
  var p1y = match$1[1];
  var p1x = match$1[0];
  var cx = circle.cx;
  var cy = circle.cy;
  var r = circle.r;
  var vx = circle.vx;
  var vy = circle.vy;
  var min_x = p1x < p2x ? p1x : p2x;
  var min_y = p1y < p2y ? p1y : p2y;
  var max_x = p1x > p2x ? p1x : p2x;
  var max_y = p1y > p2y ? p1y : p2y;
  if (cx + r <= min_x || cx - r >= max_x || cy + r <= min_y || cy - r >= max_y) {
    return circle;
  }
  var dx = p2x - p1x;
  var dy = p2y - p1y;
  var fx = cx - p1x;
  var fy = cy - p1y;
  var t = (fx * dx + fy * dy) / (dx * dx + dy * dy);
  var match$2 = t < 0.0 ? [
      p1x,
      p1y
    ] : (
      t > 1.0 ? [
          p2x,
          p2y
        ] : [
          p1x + t * dx,
          p1y + t * dy
        ]
    );
  var projection_y = match$2[1];
  var projection_x = match$2[0];
  var distance = Math.sqrt(Math.pow(cx - projection_x, 2.0) + Math.pow(cy - projection_y, 2.0));
  if (distance > r) {
    return circle;
  }
  var normal_x = (cx - projection_x) / distance;
  var normal_y = (cy - projection_y) / distance;
  var dot_product = vx * normal_x + vy * normal_y;
  var penetration_depth = r - distance;
  return {
          cx: cx + normal_x * penetration_depth,
          cy: cy + normal_y * penetration_depth,
          r: circle.r,
          vx: vx - (1 + restitution) * dot_product * normal_x,
          vy: vy - (1 + restitution) * dot_product * normal_y,
          static: circle.static,
          custom: circle.custom
        };
}

function collision_circle_circle(circle1, circle2, restitution) {
  var dx = circle2.cx - circle1.cx;
  var dy = circle2.cy - circle1.cy;
  var distance = Math.sqrt(dx * dx + dy * dy);
  var overlap = circle1.r + circle2.r - distance;
  if (overlap <= 0.0) {
    return [
            circle1,
            circle2
          ];
  }
  var match = normalize_vector([
        dx,
        dy
      ]);
  var normal_y = match[1];
  var normal_x = match[0];
  var relative_velocity_x = circle1.vx - circle2.vx;
  var relative_velocity_y = circle1.vy - circle2.vy;
  var dot_product = relative_velocity_x * normal_x + relative_velocity_y * normal_y;
  if (dot_product <= 0.0) {
    return [
            circle1,
            circle2
          ];
  }
  var impulse = (1 + restitution) * dot_product / (circle1.r + circle2.r);
  var separation = overlap / 2.0;
  var circle1$1 = circle1.static ? circle1 : ({
        cx: circle1.cx - normal_x * separation,
        cy: circle1.cy - normal_y * separation,
        r: circle1.r,
        vx: circle1.vx - impulse * normal_x,
        vy: circle1.vy - impulse * normal_y,
        static: circle1.static,
        custom: circle1.custom
      });
  var circle2$1 = circle2.static ? circle2 : ({
        cx: circle2.cx + normal_x * separation,
        cy: circle2.cy + normal_y * separation,
        r: circle2.r,
        vx: circle2.vx + impulse * normal_x,
        vy: circle2.vy + impulse * normal_y,
        static: circle2.static,
        custom: circle2.custom
      });
  return [
          circle1$1,
          circle2$1
        ];
}

function update_circles(circles, segments, gravity, dt, restitution) {
  var circles$1 = List.map((function (circle) {
          if (circle.static) {
            return circle;
          }
          var circle$1 = apply_gravity(circle, gravity, dt);
          var circle_cx = circle$1.cx + circle$1.vx * dt;
          var circle_cy = circle$1.cy + circle$1.vy * dt;
          var circle_r = circle$1.r;
          var circle_vx = circle$1.vx;
          var circle_vy = circle$1.vy;
          var circle_static = circle$1.static;
          var circle_custom = circle$1.custom;
          var circle$2 = {
            cx: circle_cx,
            cy: circle_cy,
            r: circle_r,
            vx: circle_vx,
            vy: circle_vy,
            static: circle_static,
            custom: circle_custom
          };
          return List.fold_left((function (circle, segment) {
                        return collision_circle_segment(circle, segment, restitution);
                      }), circle$2, segments);
        }), circles);
  var _circles = circles$1;
  var _acc = /* [] */0;
  while(true) {
    var acc = _acc;
    var circles$2 = _circles;
    if (!circles$2) {
      return List.rev(acc);
    }
    var match = List.fold_left((function (param, circle2) {
            var match = collision_circle_circle(param[0], circle2, restitution);
            return [
                    match[0],
                    {
                      hd: match[1],
                      tl: param[1]
                    }
                  ];
          }), [
          circles$2.hd,
          /* [] */0
        ], circles$2.tl);
    _acc = {
      hd: match[0],
      tl: acc
    };
    _circles = List.rev(match[1]);
    continue ;
  };
}

exports.apply_gravity = apply_gravity;
exports.normalize_vector = normalize_vector;
exports.collision_circle_segment = collision_circle_segment;
exports.collision_circle_circle = collision_circle_circle;
exports.update_circles = update_circles;
/* No side effect */
