(** Simple 2D physics *)

type vector = float * float
type point = float * float
type segment = point * point

type 'a circle = {
  cx: float;  (* center (cx, cy) *)
  cy: float;
  r: float;  (* radius *)
  vx: float;  (* inertia vector (vx, vy) *)
  vy: float;
  static: bool;  (* static circles don't move *)
  custom : 'a;
}

val update_circles : 'a circle list -> segment list -> vector -> float -> float -> 'a circle list
(** Update the position of multiple circles and handle collisions with:

    [update_circles circles segments gravity dt restitution]

    [restitution = 0.70], coefficient of restitution (0.70 means 30% energy loss) *)

