(** Simple 2D physics *)

type vector = float * float
type point = float * float
type segment = point * point

type 'a circle = {
  mutable cx: float;  (* center (cx, cy) *)
  mutable cy: float;
  mutable r: float;  (* radius *)
  mutable vx: float;  (* inertia vector (vx, vy) *)
  mutable vy: float;
  mutable static: bool;  (* static circles don't move *)
  custom : 'a;
}

val update_circles : 'a circle list -> segment list -> vector -> float -> float -> unit
(** Update the position of multiple circles and handle collisions with:

    [update_circles circles segments gravity dt restitution]

    [restitution = 0.70], coefficient of restitution (0.70 means 30% energy loss) *)

